 ; Ŀ
 ;   Dsc - set dimscale, snap (= 2.5 x dimscale) and ltscale.              
 ;   Dsl - set dimscale, snap (= dimscale) and ltscale.                    
 ;   Copyright 2008, 2009 by Rocket Software Ltd.                          
 ;   Overrides to a style which are set when a dimension is made remain    
 ;   part of that dimension even if the override is removed from the       
 ;   style.                                                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Stan.  Update dimscale for a named style.                             
 ;   Arguments: Stnam, a dimension style name.                             
 ;              Scal, a dimscale.                                          
 ;   Calls nothing, returns nothing.                                       
 ;   Changing dimvars in a style: make the dimstyle current, using the     
 ;   -dimstyle command (as opposed to the Dimstyle command which brings    
 ;   up the Ddim dialog box, or the Dimstyle system variable.)             
 ;   Then update the required dimvars (which temporarily become overrides) 
 ;   and then save the style, which makes the overrides part of it.        
 ; 
 (DEFUN STAN (stnam scal /)
 ; Ŀ
 ;   If the style exists, make it current.  If not then make it.           
 ;   The latter action will apparently copy the current style to the new   
 ;   name, so the new style will need to be set up properly.               
 ; 
  (if (tblsearch "dimstyle" stnam)
      (command "-dimstyle" "restore" stnam)
      (command "-dimstyle" "save" stnam))
 ; Ŀ
 ;   Change dimscale.  This becomes an override to the current style.      
 ; 
  (setvar "dimscale" scal)
 ; Ŀ
 ;   Save the style: since it is current and there are overrides on it     
 ;   they are written back to it and nothing else is changed.              
 ;   Technically, saving a dimstyle makes a copy of the current style      
 ;   with any overrides and saves that to the name given to the save       
 ;   command.                                                              
 ;   So saving any style other than the current one is a dubious idea:     
 ;   if we weren't writing the current style then a copy of the current    
 ;   style with any overrides applied would overwrite Stnam.               
 ;   Making a style current (which saving it does) discards overrides      
 ;   to the previous current style.  This implies that only the current    
 ;   style can have overrides.                                             
 ;   Note that the if statement isn't really necessary since we made       
 ;   stnam earlier if it didn't exist.                                     
 ;   Also note that if Stnam was already the current dimstyle and has      
 ;   overrides then they will become part of the style.                    
 ; 
  (if (tblsearch "dimstyle" stnam)
      (command "dimstyle" "save" stnam "y")
      (command "dimstyle" "save" stnam))
 (princ))
 ; Ŀ
 ;   Stan end.                                                             
 ; 

 ; Ŀ
 ;   Dsl.                                                                  
 ; 
 (DEFUN C:DSL (/ stnam disc)
  (setvar "cmdecho" 0)
  (setq stnam "STANDARD")
  (stan stnam (setq disc (getreal "Scale: ")))
  (setvar "ltscale" (* 10 disc))
  (command "snap" (rtos disc))
 (princ))

 ; Ŀ
 ;   Dsc.                                                                  
 ; 
 (DEFUN C:DSC (/ stnam disc snapsc)
  (setvar "cmdecho" 0)
  (setq stnam "STANDARD")
  (stan stnam (setq disc (getreal "Scale: ")))
  (setvar "ltscale" (* 10 disc))
  (setq snapsc (rtos (* 2.5 disc)))
  (command "snap" snapsc)
 (princ))